# Definition for managing ssl certs for Intelligest
define twitch_intelligest::ssl_certificate (
  $sandstorm_key_path,
  $ensure                = 'present',
  $sandstorm_cert_path   = undef,
  $sandstorm_cert_prefix = undef,
) {
  include twitch_intelligest

  $cert_file       = "${twitch_intelligest::params::tls_dir}/${title}.crt"
  $key_file        = "${twitch_intelligest::params::tls_dir}/${title}.key"
  $restart_command = '/bin/systemctl reload intelligest'

  $_contents = $sandstorm_cert_prefix ? {
    undef   => "{{ key \"${sandstorm_cert_path}\" }}",
    default => template("${module_name}/sandstorm-cert.erb"),
  }

  # The actual certificate
  twitch_ssl_certificate::certificate { "${title}.crt":
    ensure               => $ensure,
    cert_filesystem_path => $cert_file,
    cert_contents        => $_contents,
    cert_owner           => 'root',
    cert_group           => 'intelligest',
    cert_mode            => '0640',
    cert_restart_cmd     => $restart_command,
    require              => File[$twitch_intelligest::params::tls_dir],
  }

  # The key is a separate file
  twitch_sandstorm_agent::template { "${title}.key":
    ensure          => $ensure,
    destination     => $key_file,
    key             => $sandstorm_key_path,
    owner           => 'root',
    group           => 'intelligest',
    mode            => '0640',
    restart_command => $restart_command,
    require         => File[$twitch_intelligest::params::tls_dir],
  }
}
