# @summary
#  This class dictates configuration knobs for twitch_inventory_agent depending on whether its purpose is
#  for netboot generation or for ongoing production usage in the monolith
#
class twitch_inventory_agent::config {

  include twitch_unattended_upgrades

  # Using Unattended-Upgrade::Package-Whitelist causes all other packages to
  # not update. Use a cronjob instead. Delete this once all hosts run puppet
  # agent on a schedule.
  cron::job { 'inventory-agent-install':
    ensure      => 'present',
    command     => 'apt-get install -y twitch-inventoryagent >/dev/null 2>&1',
    user        => 'root',
    environment => [
      'DEBIAN_FRONTEND=noninteractive',
      'PATH=/bin:/usr/bin:/sbin:/usr/sbin:/usr/local/bin:/usr/local/sbin',
    ],
    minute      => fqdn_rand(59, $title),
    hour        => fqdn_rand(23, $title),
  }

}
