# twitch_inventory_agent
#
# Main class, includes all other classes.
#
# @param ensure
#   An array of kernel packages. Default: 'present'.
#
# @param pin_version
#   Decides whether or not to pin the installation of the inventory-agent package to a specific version
#   If this value is not defined, the service will default to latest and unattended upgrades will be configured to update the version.
#
class twitch_inventory_agent (
  $ensure      = $twitch_inventory_agent::params::ensure,
  $pkg_version = $twitch_inventory_agent::params::pkg_version,
) inherits twitch_inventory_agent::params{

  if $ensure == 'present' {
    anchor { '::twitch_inventory_agent::begin': }
    -> class { '::twitch_inventory_agent::config': }
    -> class { '::twitch_inventory_agent::install': }
    ~> class { '::twitch_inventory_agent::service': }
    -> anchor { '::twitch_inventory_agent::end': }
  } else {
    anchor { '::twitch_inventory_agent::begin': }
    -> class { '::twitch_inventory_agent::service': }
    -> class { '::twitch_inventory_agent::install': }
    -> anchor { '::twitch_inventory_agent::end': }
  }
}
