# @summary
#  This class decides whether to install the inventory agent (at a particular version vs. latest) or remove it.
#
class twitch_inventory_agent::install {
  include twitch_inventory_agent

  $pkg_ensure = $twitch_inventory_agent::ensure ? {
    'present' => $twitch_inventory_agent::pkg_version,
    default   => absent,
  }

  package { 'twitch-inventoryagent':
    ensure => $pkg_ensure,
  }

  # the monolith manages this (though this file is installed by the package) 
  # so removing it will force puppet to remove the file as well.
  sudo::conf { 'ttv-inventoryagent':
    ensure   => $twitch_inventory_agent::ensure,
    priority => 99,
    require  => Package['twitch-inventoryagent'],
  }
}
