# @summary
#  This class dictates whether the service that is installed should be enabled or disabled.
#  This provides a cleaner way to control via puppet the intent to fully remove/uninstall the service.
#
class twitch_inventory_agent::service {

  if $twitch_inventory_agent::ensure == 'present' {
    $service_enable = true
  } else {
    $service_enable = false
  }

  service { 'inventory-agent':
    enable => $service_enable,
  }
}
