#!/bin/bash

ROTATE_CONF=false
CONMAN_CONF=/usr/local/etc/conman.conf
OUTPUT_FILE=/usr/local/bin/devices.txt
TMP_OUTPUT_FILE=/usr/local/bin/devices.txt.tmp
COMP_FILE=/usr/local/bin/completion.txt

/usr/local/bin/get_mysql_ipmi_info.py 2>/dev/null | awk '{ print $1, $2, $3 }' > ${TMP_OUTPUT_FILE}

cmp --silent ${OUTPUT_FILE=} ${TMP_OUTPUT_FILE} || ROTATE_CONF=true

if [ "${ROTATE_CONF}" = true ]; then
        diff -u ${OUTPUT_FILE} ${TMP_OUTPUT_FILE}
        mv -f ${TMP_OUTPUT_FILE} ${OUTPUT_FILE}
        echo "md5sum changed, restarting conman"
        cp -f ${CONMAN_CONF}.base ${CONMAN_CONF}
        awk '{ print $1 }' ${OUTPUT_FILE} > ${COMP_FILE}
        awk '{ print "console name=\""$1"\" dev=\"ipmi:"$2"\" # "$3 }' ${OUTPUT_FILE} >> ${CONMAN_CONF}
#        awk '{ print "console name=\""$1"\" dev=\"ipmi:"$2"\"" }' ${OUTPUT_FILE} >> ${CONMAN_CONF}
        /etc/init.d/conmand reload
else
        echo "md5sum not changed, doing nothing"
fi

if [ -f "${TMP_OUTPUT_FILE}" ]
then
  rm "${TMP_OUTPUT_FILE}"
fi
