#!/usr/bin/env python
import json
import os
import sys
import os.path
import MySQLdb, MySQLdb.cursors
from configobj import ConfigObj


DB_CONFIG = '/etc/provisioner/config'

def mysql_connect(db_config):
    config = ConfigObj(db_config)

    return MySQLdb.connect(host=config.get('DB_HOST'),
                           user=config.get('DB_USERNAME'),
                           passwd=config.get('DB_PASSWORD'),
                           db=config.get('DB_DATABASE'),
                           cursorclass=MySQLdb.cursors.DictCursor)

def get_ipmi_ips(db_config):
    db = mysql_connect(db_config)
    c = db.cursor()

    c.execute("""
                SELECT  d.id,
                        d.uuid,
                        MAX(INET_NTOA(ia.ip)) AS ipmi_ip
                FROM devices d
                    JOIN ip_addresses ia ON
                        (d.id = ia.device_id)
                WHERE ia.label = 'ipmi'
                GROUP BY 1""")

    result = c.fetchall()

    for v in result:
        if v.get('ipmi_ip') == '0.0.0.0':
            continue
        print "{} {} {}".format(
            v.get('uuid'),
            v.get('ipmi_ip'),
            v.get('id'))


if __name__ == '__main__':
    get_ipmi_ips(DB_CONFIG)
