class twitch_ipmi_services::conman inherits twitch_ipmi_services {
  $package_names = ['python-mysqldb', 'python-configobj', 'conman']

  # conman and some dependencies needed for cronjobs
  package { $package_names: }

  file { '/etc/provisioner/':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
  }

  # config needed for get_mysql_ipmi_info.py
  file { '/etc/provisioner/config':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0640',
    content => template("${module_name}/provisioner_config.erb"),
    require => File['/etc/provisioner/'],
  }

  # supporting script to populate conman config
  file { '/usr/local/bin/get_ipmi_info.sh':
    source => "puppet:///modules/${module_name}/get_ipmi_info.sh",
    owner  => 'root',
    group  => 'root',
    mode   => '0700',
  }

  file { '/usr/local/bin/get_mysql_ipmi_info.py':
    source => "puppet:///modules/${module_name}/get_mysql_ipmi_info.py",
    owner  => 'root',
    group  => 'root',
    mode   => '0700',
  }

  # run once to setup file
  exec { 'get_ipmi_info.sh':
    path    => [ '/usr/local/bin/', '/usr/bin/', '/bin/' ],
    creates => '/usr/local/etc/conman.conf',
    require => File[
      '/usr/local/bin/get_ipmi_info.sh',
      '/usr/local/bin/get_mysql_ipmi_info.py',
      '/usr/local/etc/conman.conf.base',
      '/etc/init.d/conmand'
    ],
  }

  file { $conman_logdir:
    ensure => 'directory',
  }

  # TODO: SANDSTORM
  file { '/usr/local/etc/conman.conf.base':
    owner   => 'root',
    group   => 'root',
    mode    => '0600',
  }

  file { '/etc/init.d/conmand':
    source => "puppet:///modules/${module_name}/conmand",
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  service { 'conmand':
    ensure  => 'running',
    enable  => true,
    require => [
      Exec['get_ipmi_info.sh'],
      Package[$package_names],
      File['/etc/init.d/conmand']
    ],
  }

  # This runs every minute.
  cron::job { 'ipmi-info':
    command => '/usr/local/bin/get_ipmi_info.sh 2>&1 | logger -t ipmi-info -p local3.info',
    user    => 'root',
    require => File[
      '/usr/local/bin/get_ipmi_info.sh',
      '/usr/local/bin/get_mysql_ipmi_info.py',
      '/usr/local/etc/conman.conf.base'
    ],
  }

}
