class twitch_ipmi_services::powerservice {

  file { '/etc/powerservice/':
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
  }

  # TODO: SANDSTORM
  file { '/etc/powerservice/config':
    ensure  => present,
    owner   => 'powerservice',
    group   => 'root',
    mode    => '0460',
  }

  twitch::service { 'powerservice':
    deploy_env     => ['production'],
    predaemon      => [],
    daemon_cmd     => './powerservice --config /etc/powerservice/config',
    service_repo   => 'systems/powercycle_service',
    manage_service => true,
  }

  twitch_nginx::vhost { 'powerservice':
    content => template("${module_name}/powerservice.conf.erb"),
    require => Twitch::Service['powerservice'],
  }

}
