# twitch_ipv6

## Overview

Manage ipv6 settings / preferences / config files. Replaces using core::sysctl for
ipv6 /proc settings.

## Usage

```
include twitch_ipv6

class { 'twitch_ipv6':
    enable => false
}
```

### Parameters
#### `enable`
 * false - Disable ipv6. This keeps in sync with previous core::sysctl settings. This is the default.
 * true - Enable ipv6 and preferred ipv4 dns over ipv6.

### Managed files
#### `/etc/gai.conf`
Settings default to glibc's orignal settings. When twitch_ipv6::enable is set to `true`, ipv4 preference is set over ipv6 when making requests.
