# twitch_ipv6::gai_conf - manages ip version preference
define twitch_ipv6::gai_conf (
  $gai_labels,
  $gai_precedence,
  $gai_scopev4,
  $prefer_ipv4 = false,
) {

  if str2bool($prefer_ipv4) {
    $_gai_precedence = merge($gai_precedence, {'::ffff:0:0/96' => 100})
  } else {
    $_gai_precedence = $gai_precedence
  }

  file { '/etc/gai.conf':
    ensure  => file,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/gai.conf.erb"),
  }

}
