# twitch_ipv6 - manage ipv6 settings
class twitch_ipv6 (
  $enable = $twitch_ipv6::params::enable,
) inherits twitch_ipv6::params {

  validate_bool($enable)

  # All interfaces found plus:
  # 'default' - set the default for when interfaces are created
  # 'all'     - may change every interface specific value
  #             but varies depending on setting type
  $physical_interfaces = concat (split($::interfaces_with_link, ','), 'all', 'default')

  # Follow ipv6 setting
  twitch_ipv6::gai_conf { 'ipv6':
    prefer_ipv4    => $enable,
    gai_labels     => $twitch_ipv6::gai_labels,
    gai_precedence => $twitch_ipv6::gai_precedence,
    gai_scopev4    => $twitch_ipv6::gai_scopev4,
  }

  # always disable $physical_interfaces
  twitch_ipv6::interface { $physical_interfaces: ensure => false  }

  # apply to loopback
  twitch_ipv6::interface { 'lo': ensure => $enable  }

  # apply sysctl to $default_gateway_interface if not
  # listed in $physical_interfaces
  if ! ($::default_gateway_interface in $physical_interfaces) {
    twitch_ipv6::interface { $::default_gateway_interface: ensure => $enable }
  }

}
