# twitch_ipv6::interface - enable ipv6 per interface
define twitch_ipv6::interface(
  $ensure = true
) {

  include twitch_ipv6

  $value = str2bool($ensure) ? {
    false => 1,
    default => 0
  }

  $sysctl_common= {
    "net.ipv6.conf.${name}.accept_redirects"         => { value => 0 },
    "net.ipv6.conf.${name}.accept_ra"                => { value => 0 },
    "net.ipv6.conf.${name}.dad_transmits"            => { value => 0 },
    "net.ipv6.conf.${name}.accept_dad"               => { value => 0 },
    "net.ipv6.conf.${name}.router_solicitations"     => { value => 0 },
    "net.ipv6.conf.${name}.accept_ra_rtr_pref"       => { value => 0 },
    "net.ipv6.conf.${name}.accept_ra_pinfo"          => { value => 0 },
    "net.ipv6.conf.${name}.accept_ra_defrtr"         => { value => 0 },
    "net.ipv6.conf.${name}.autoconf"                 => { value => 0 },
    "net.ipv6.conf.${name}.forwarding"               => { value => 0 },
    "net.ipv6.conf.${name}.mc_forwarding"            => { value => 0 },
  }

  create_resources(sysctl::value,$sysctl_common)

  $sysctl = { "net.ipv6.conf.${name}.disable_ipv6" => { value => $value } }

  create_resources(sysctl::value,$sysctl)

}
