# twitch_ipv6::params default settings for twitch_ipv6 class
class twitch_ipv6::params {

  # default to disable ipv6
  $enable = false

  # default labels according to libc
  $gai_labels = {
    '::1/128'       => 0,
    '::/0'          => 1,
    '2002::/16'     => 2,
    '::/96'         => 3,
    '::ffff:0:0/96' => 4,
    'fec0::/10'     => 5,
    'fc00::/7'      => 6,
    '2001:0::/32'   => 7
  }

  # default precedence according to libc
  $gai_precedence = {
    '::1/128'       => 50,
    '::/0'          => 40,
    '2002::/16'     => 30,
    '::/96'         => 20,
    '::ffff:0:0/96' => 10
  }

  # default scopev4 according to libc
  $gai_scopev4 = {
    '::ffff:169.254.0.0/112' => 2,
    '::ffff:127.0.0.0/104'   => 2,
    '::ffff:0.0.0.0/96'      => 14
  }

}
