# twitch_irqbalance

## Overview 

Manage irqbalance

## Usage

```puppet
include twitch_irqbalance

class { 'twitch_balance': }
```
Manage irqbalance service, configs and policy scripts.

You can also override with hiera:
```puppet
twitch_irqbalance::policyscript: 'name_of_policy_script'
twitch_irqbalance::service_ensure: true
twitch_irqbalance::oneshot: true
```

### Parameters
#### `policyscript`
Script filename that irqbalance will run. Remember to place your policy script in the files directory.

#### `service_ensure`
Enable or disable the irqbalance service. Valid values, `stopped` and `running` (default).
NOTE: it is advised to create a policy script instead of disabling the irqbalance service. Other IRQ's device may still benefit with the service on.

#### `oneshot`
Causes irqbalance to be run once, after which the daemon exits. Valid values, `false` (default) and `true`.

## Caveats
* The version of logrotate on Ubuntu 12.04 / precise will silently ignore `policyscript` and continue as normal without erroring.
