#
# return a fact for each network driver inuse
# each fact will list the interface names using that driver
# 
modules = Hash.new {|h,k| h[k] = [] }
Dir.glob("/sys/class/net/*/").each do |file|
  interface_name = File.basename(file)
  if File.exists?(file + "device/driver")
    driver = File.basename(File.readlink(file + "device/driver"))
    modules[driver].push(interface_name)
  end
end
modules.each do |key, value|
  Facter.add('interfaces_' + key) do
    setcode do
      value.sort.join(',')
    end
  end
end
