# Single run to distribute irqs on a running system. Only run after changes
# have been made to irqbalance service/configs. irqbalance will then 
# manage/not manage irqs as configured. Removes the need of requiring a
# reboot to manage irqs properly.
class twitch_irqbalance::distribute_irqs (
  $apply_live        = $twitch_irqbalance::params::apply_live,
  $apply_live_script = $twitch_irqbalance::params::apply_live_script,
) inherits twitch_irqbalance::params {

  include twitch_irqbalance

  $apply_live_ensure = $apply_live ? {
    true    => 'present',
    default => 'absent',
  }

  $apply_live_source = $apply_live ? {
    true    => template("${module_name}/${apply_live_script}.erb"),
    default => undef,
  }

  file {'/usr/local/bin/distribute_irqs.sh':
    ensure  => $apply_live_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => $apply_live_source,
  }

  if ($apply_live) {
    exec {'distributing irqs':
      command   => '/usr/local/bin/distribute_irqs.sh',
      refreshonly => true,
      subscribe => Service['irqbalance'],
      require   => File['/usr/local/bin/distribute_irqs.sh'],
    }
  }

}
