# wrapper for irqbalance
class twitch_irqbalance (
  $policyscript   = $twitch_irqbalance::params::policyscript,
  $service_ensure = running,
  $oneshot        = false,
) inherits twitch_irqbalance::params {

  validate_bool($oneshot)
  validate_re($service_ensure, ['^running$','^stopped$'])

  include twitch_irqbalance::distribute_irqs

  if versioncmp($::lsbmajdistrelease, '18.04') >= 0 {
    $default_irqbalance = 'irqbalance.v2.erb'
  } else {
    $default_irqbalance = 'irqbalance.v1.erb'
  }

  $use_policyscript = $policyscript ? {
    /^\w+/  => 'present',
    default => 'absent',
  }

  $use_oneshot = $oneshot ? {
    true    => '1',
    default => '0'
  }

  $enabled = $service_ensure ? {
    'running' => '1',
    default   => '0'
  }

  $policyscript_path = "/usr/local/bin/irqbalance_policy.sh"

  $options = $use_policyscript ? {
    'present' => "-l ${policyscript_path}",
    default   => undef,
  }

  file { $policyscript_path:
    ensure => $use_policyscript,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    source => "puppet:///modules/${module_name}/${policyscript}",
  }

  ~> package { 'irqbalance':
    ensure => present
  }

  ~> file { '/etc/default/irqbalance':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/${default_irqbalance}"),
  }

  ~> service { 'irqbalance':
    ensure => $service_ensure,
    enable => true
  }

}
