# @summary
#   This class configures desired kernel pinning if specified
#
class twitch_kernel::config {

if ($twitch_kernel::pin_kernel_version) {

  include twitch_apt
  # maintain parity with puppet-monolith where pins are configured for each package
  # (whether or not this was the desired implementation is unknown).
  apt::pin { $twitch_kernel::kernel_packages:
    ensure   => present,
    packages => $twitch_kernel::kernel_packages,
    priority => 600,
    version  => $twitch_kernel::kernel_version,
  }
}

}
