# twitch_kernel
#
# Main class, includes all other classes.
#
# @param kernel_packages
#   An array of kernel packages. Default: ['linux-modules-extra-4.15.0-54-generic'].
#
# @param kernel_version
#   The specific version of the array of kernel packages described above. Default: 4.15.0-54.58~16.04.1.
#
# @param kernel_packages_exclude
#   An optionally defined array of kernel packages to exclude/ensure they are absent.
#   Some kernel meta-packages implicitly install dependencies that will install kernel that are not intended to be pinned.
#   Default value: [].
#
# @param pin_kernel_version
#   Whether or not to pin the kernel version so other versions of the kernel are not installed by apt. Default: false.
#
class twitch_kernel (
  $kernel_packages         = $twitch_kernel::params::kernel_packages,
  $kernel_header_packages  = $twitch_kernel::params::kernel_header_packages,
  $kernel_version          = $twitch_kernel::params::kernel_version,
  $kernel_packages_exclude = $twitch_kernel::params::kernel_packages_exclude,
  $pin_kernel_version      = $twitch_kernel::params::pin_kernel_version,

  ) inherits twitch_kernel::params {

  validate_bool($pin_kernel_version)
  validate_array($kernel_packages, $kernel_header_packages, $kernel_packages_exclude)

  contain twitch_kernel::config
  contain twitch_kernel::install

  Class['twitch_kernel::config']
  -> Class['twitch_kernel::install']
}
