# @summary
#   This class installs the list of desired kernel packages and optionally uninstalls the list of excluded kernel packages.
#
class twitch_kernel::install {

  $ensure_headers = defined('$packer_build_name') ? {
    true   => 'absent',
    default => $twitch_kernel::kernel_version,
  }

  # install desired kernel packages at the specific version.
  package { $twitch_kernel::kernel_packages:
    ensure => $twitch_kernel::kernel_version,
  }

  package { $twitch_kernel::kernel_header_packages:
    ensure => $ensure_headers,
  }

  # uninstall any undesired kernel packages that may have been included
  # as a meta-package dependency.
  if (size($twitch_kernel::kernel_packages_exclude) > 0){
    package { $twitch_kernel::kernel_packages_exclude:
      ensure => 'absent',
    }
  }

}
