# @summary
#  These are the configurable parameters for twitch_kernel
#
class twitch_kernel::params {
  if $::cmdline['boot'] == 'live' or $::packer_build_name {
    $pin_kernel_version = false
  } else{
    $pin_kernel_version = true
  }
  case $::lsbdistcodename {
    'xenial': {
      # Baremetal vs AWS HWE enabled kernel
      if $::ec2_metadata != undef {
        $kernel_packages = [
          'linux-modules-4.15.0-1043-aws',
          'linux-image-4.15.0-1043-aws',
        ]
        $kernel_header_packages = [ 'linux-aws-headers-4.15.0-1043' ]
        $kernel_packages_exclude = []
        $kernel_version  = '4.15.0-1043.45~16.04.1'
      }
      else {
        $kernel_packages = [
          'linux-modules-extra-4.15.0-54-generic',
          'linux-image-4.15.0-54-generic',
        ]
        $kernel_header_packages = [
          'linux-headers-4.15.0-54',
          'linux-headers-4.15.0-54-generic',
        ]
        $kernel_packages_exclude = [
          'linux-generic-hwe-16.04',
          'linux-generic-hwe-16.04-edge',
          'linux-image-generic-hwe-16.04',
          'linux-headers-generic-hwe-16.04',
        ]
        $kernel_version  = '4.15.0-54.58~16.04.1'
      }
    }
    'bionic': {
      if $::ec2_metadata != undef {
        $kernel_packages = [
          'linux-modules-5.4.0-1049-aws',
          'linux-image-5.4.0-1049-aws'
        ]
        $kernel_header_packages = [ 'linux-headers-5.4.0-1049-aws' ]
        $kernel_packages_exclude = []
        $kernel_version  = '5.4.0-1049.51~18.04.1'
      }
      else {
        $kernel_packages = [
          'linux-image-5.3.0-42-generic',
          'linux-modules-extra-5.3.0-42-generic',
        ]
        $kernel_header_packages = [
          'linux-headers-5.3.0-42-generic',
          'linux-headers-5.3.0-42',
        ]
        $kernel_packages_exclude = [
          'linux-generic-hwe-18.04',
          'linux-generic-hwe-18.04-edge',
          'linux-image-generic-hwe-18.04',
          'linux-headers-generic-hwe-18.04',
          'linux-image-generic',
          'linux-headers-generic',
        ]
        $kernel_version  = '5.3.0-42.34~18.04.1'
      }
    }
    'focal':{
      $kernel_packages = [
        'linux-image-5.8.0-55-generic',
        'linux-modules-extra-5.8.0-55-generic',
      ]
      $kernel_header_packages = [
        'linux-headers-5.8.0-55-generic',
        'linux-headers-5.8.0-55',
      ]
      $kernel_packages_exclude = [
        'linux-generic-hwe-20.04',
        'linux-generic-hwe-20.04-edge',
        'linux-image-generic-hwe-20.04',
        'linux-headers-generic-hwe-20.04',
        'linux-image-generic',
        'linux-headers-generic',
      ]
      $kernel_version  = '5.8.0-55.62~20.04.1'
    }
    default: {
      fail("release unsupported - ${::lsbdistcodename}")
    }
  }
}
