# twitch_ldap
class twitch_ldap {

  require twitch_apt

  $sssd_packages = ['auth-client-config', 'libpam-sss', 'libnss-sss', 'ca-certificates', 'sssd']
  $acc_profile_filename = '/etc/auth-client-config/profile.d/twitch_sss'

  package { $sssd_packages:
    ensure => present,
  }

  -> file { '/etc/sssd/sssd.conf':
    ensure => 'present',
    owner  => 'root',
    group  => 'root',
    mode   => '0600',
    source => "puppet:///modules/${module_name}/etc/sssd/sssd.conf",
  }

  -> file { $acc_profile_filename:
    ensure => present,
    owner  => 'root',
    group  => 'root',
    mode   => '0644',
    source => "puppet:///modules/${module_name}/${acc_profile_filename}",
  }

  ~> exec { '/usr/sbin/auth-client-config -a -p twitch_sss':
    unless  => '/usr/sbin/auth-client-config -s -a -p twitch_sss',
  }

}
