# OpenDJ LDAP Directory Server v2

Module to install and configure OpenDJ Directory Server.

  1. Installs `opendj` package from our internal repo
  3. Runs opendj's setup script if needed
  4. Manages `opendj` systemd unit and service
  5. Configures replication, if needed.
  6. Sets up password policies and SSL.

Installation
------------

This module requires Sandstorm access to the following keys:

- `syseng/ldap/production/*` (6 or more secrets)


Replication
-----------

To have this module set up replication, you'll need to tell it who is the master
server. We can't just use the `ldap_server` value from hiera, since this module
will likely be going on our PoPmasters, which are going to act as the `ldap_server`
for the PoPs they are master-ing. Replication is only enabled if a master is specified.

    twitch_ldap_server::replication::master: ldap-da0830.sjc02.justin.tv

If this should be a read-only slave (running on a PoPmaster, for example), turn
that on:

    twitch_ldap_server::replication::readonly: true
