# Sets up anycast address for LDAP.
#
class twitch_ldap_server::anycast (
  $community = 16019,
  $ip        = undef,
  $ip_ro     = undef,
) {
  include twitch_ldap_server
  if !$::disable_anycast and ($ip or $ip_ro) {
    include bird::monitoring
    include twitch_anycast_health_enforcer::monitoring
    validate_integer($community)
    $check_interval_secs = 30
    twitch_anycast_health_enforcer::service { 'ldap':
      interval   => '1m',
      rise       => 2,
      fall       => 2,
      addresses  => delete_undef_values([$ip,$ip_ro]),
      community  => $community,
      checks     => {
        "/usr/lib/nagios/plugins/check_ldaps --port 636 -H localhost -b 'dc=justin,dc=tv' -t ${check_interval_secs}" => {
          type    => 'cmd',
          timeout => "${check_interval_secs}s",
        },
      },
    }
  }
}
