# Sets up backup script to s3 and configures OpenDJ to do daily backups
# script_path: Location these scripts will be on disk
# it_dev_host: Dev host to send a copy of the backup to
class twitch_ldap_server::backup (
  $backup_key,
  $install_dir      = twitch_ldap_server::install_dir,
  $setup_pass_file  = twitch_ldap_server::setup_pass_file,
  $baskup_s3_bucket = twitch_ldap_server::backup_s3_bucket,
) inherits twitch_ldap_server::params {
  include twitch_ldap_server

  file { "${install_dir}/twitch_scripts/daily_backup.sh":
    content => template("${module_name}/daily_backup.sh.erb"),
    mode    => '0750',
  }

  cron::job { 'opendj-backup':
    ensure  => present,
    command => "${install_dir}/twitch_scripts/daily_backup.sh 2>&1 | logger -p local3.warn -t s3backup",
    hour    => '3',
    minute  => '0',
  }

  exec { "${install_dir}/twitch_scripts/enable_backups.sh":
    refreshonly => true,
    require     => Twitch_sandstorm_agent::Resource['opendj_setup'],
  }

  file { "${install_dir}/twitch_scripts/enable_backups.sh":
    content => template("${module_name}/enable_backups.sh.erb"),
    notify  => Exec["${install_dir}/twitch_scripts/enable_backups.sh"],
    mode    => '0755',
  }
}
