# Install and configure opendj
class twitch_ldap_server (
  $backup_s3_bucket = $twitch_ldap_server::params::backup_s3_bucket
  ) inherits twitch_ldap_server::params {
  include twitch_ldap_server::anycast
  include core
  $env = pick($twitch_environment, $::twitch_environment)

  anchor { "${module_name}::start": }
  -> class { "${module_name}::install": }
  -> class { "${module_name}::config": }
  -> class { "${module_name}::service": }
  -> class { "${module_name}::replication": }
  -> class { "${module_name}::postconfig": }
  -> class { "${module_name}::logging": }
  -> anchor { "${module_name}::end": }
  if $env == 'production' {
    twitch_servicecheck::active { 'LDAP':
      command => 'check_ldap',
    }
    twitch_servicecheck::passive { 'LDAP_Rep':
      command  => 'sudo /usr/local/monitor_scripts/check_ldap.sh -w 14400 -c 43200',
      user     => 'nagios',
      interval => 10,
      retry    => 2,
    }
    twitch_servicecheck::passive { 'LDAPS Cert Valid':
      command  => 'check_http -S -I 127.0.0.1 -p 636 -C 31,14',
      interval => 10,
      retry    => 2,
      options  => {
        notes_url => 'https://wiki.twitch.com/display/SYS/Update+OpenDJ+LDAP+SSL+Certificate',
      },
    }
  }
}
