# Install steps for opendj
class twitch_ldap_server::install (
  $version     = $twitch_ldap_server::params::opendj_version,
  $install_dir = $twitch_ldap_server::params::install_dir,
) inherits twitch_ldap_server::params {
  require java # opendj is java
  include twitch_ldap_server
  include twitch_python::python_ldap

  package { 'opendj':
    ensure  => $version,
    require => Apt::Source['twitch']
  }

  package { 'ldap-utils':
    ensure => 'installed',
  }
  # ensure directory is owned properly by the service owner
  # recursive file ownership check
  file { [$install_dir,
          "${install_dir}/logs",
          "${install_dir}/locks"]:
    ensure  => 'directory',
    owner   => 'root',
    group   => 'root',
    recurse => true,
    require => Package['opendj'],
  }

  file { "${install_dir}/twitch_scripts":
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
  }

  $opendj_select = $::lsbdistcodename ? {
    'xenial' => 'OpenDJCollector',
    default  => 'NewOpenDJCollector',
  }
  ensure_resource('twitch_diamond::collector', $opendj_select, {
    enable  => true,
    source  => true,
    require => Class['twitch_python::python_ldap'],
  })
}
