# Logging setup for opendj
class twitch_ldap_server::logging (
  $output_tag  = 'syslog_elasticsearch',
  $install_dir = $twitch_ldap_server::install_dir,
) inherits twitch_ldap_server::params {
  include twitch_ldap_server

  video_cloudwatch::logfile { 'opendj-access':
    file_path        => "${install_dir}/logs/access",
    timestamp_format => '%d/%b/%Y:%H:%M:%S %z',
  }

  video_cloudwatch::logfile { 'opendj-errors':
    file_path        => "${install_dir}/logs/errors",
    timestamp_format => '%d/%b/%Y:%H:%M:%S %z',
  }

  video_cloudwatch::logfile { 'opendj-replication':
    file_path        => "${install_dir}/logs/replication",
    timestamp_format => '%d/%b/%Y:%H:%M:%S %z',
  }

}
