# Post configuration takes place after opendj is running.
#
class twitch_ldap_server::postconfig (
  $setup_pass_file = $twitch_ldap_server::params::setup_pass_file,
  $install_dir     = $twitch_ldap_server::params::install_dir,
) inherits twitch_ldap_server::params {
  # used by postconfig template

  include twitch_ldap_server
  # Setup password policies.
  file { "${install_dir}/twitch_scripts/password_policies.sh":
    content => template("${module_name}/password_policies.sh.erb"),
    notify  => Exec["${install_dir}/twitch_scripts/password_policies.sh"],
    mode    => '0755',
  }

  exec { ["${install_dir}/twitch_scripts/password_policies.sh",
          "${install_dir}/twitch_scripts/postconfig.sh"]:
    refreshonly => true,
  }

  file { "${install_dir}/twitch_scripts/postconfig.sh":
    content => template("${module_name}/postconfig.sh.erb"),
    notify  => Exec["${install_dir}/twitch_scripts/postconfig.sh"],
    mode    => '0755',
  }
}
