# Setup replication scripts for opendj
class twitch_ldap_server::replication (
  $sandstorm_key         = "syseng/ldap/${twitch_ldap_server::env}/replicationadmin",
  $group                 = 4000,
  $server                = false,
  $readonly              = true,
  $enable_auto           = false,
  $master                = undef,
  $install_dir           = $twitch_ldap_server::params::install_dir,
  $setup_pass_file       = $twitch_ldap_server::params::setup_pass_file,
  $replication_pass_file = $twitch_ldap_server::params::replication_pass_file,
) inherits twitch_ldap_server::params {

  twitch_ldap_server::user { 'replicationadmin':
    password_key => $sandstorm_key,
    admin        => true,
  }

  file { "${install_dir}/twitch_scripts/auto_replication.sh":
    content => template("${module_name}/auto_replication.sh.erb"),
    mode    => '0750',
  }

  # Don't auto replicate by default, this takes to long
  if $enable_auto {
    exec { "${install_dir}/twitch_scripts/auto_replication.sh":
      creates => "${install_dir}/replication_configured",
      # Set the timeout on this to 20 minutes. It's ugly, but apparently OpenDJ
      # can only initialize replication to one server at a time, so if we're
      # bringing up 4 PoPmasters at the same time, 3 of them will be waiting
      # for the first one to finish.
      timeout => 1200,
      require => [
        File["${install_dir}/twitch_scripts/auto_replication.sh"],
        Twitch_ldap_server::User['replicationadmin'],
      ],
    }
  }
}
