# Configures an LDAP server to restore from the backups.
class twitch_ldap_server::restore (
  $install_dir = $twitch_ldap_server::params::install_dir,
) inherits twitch_ldap_server::params {
  include twitch_ldap_server
  # Creds for uploading the backup
  file { "${install_dir}/twitch_scripts/restore_from_latest.sh":
    content => template("${module_name}/restore_from_latest.sh.erb"),
    mode    => '0750',
  }

  cron::job { 'opendj-backup-restore':
    ensure  => present,
    command => "${install_dir}/twitch_scripts/restore_from_latest.sh 2>&1 | logger -p local3.warn -t ldap_restore",
    hour    => '4',
    minute  => '0',
  }
}
