# Ensure startup type files and settings are present
class twitch_ldap_server::service (
  $install_dir = $twitch_ldap_server::params::install_dir,
  $ldaps_port  = $twitch_ldap_server::params::ldaps_port,
  $enable      = true,
) inherits twitch_ldap_server::params {
  include twitch_ldap_server
  validate_absolute_path($install_dir)

  twitch_systemd::service { 'opendj':
    enable  => $enable,
    command => "${install_dir}/bin/start-ds --quiet",
    stopcmd => "${install_dir}/bin/stop-ds --quiet",
    cwd     => $install_dir,
    pidfile => "${install_dir}/logs/server.pid",
    nofile  => 200000,
    user    => 'root',
    restart => 'always',
    timeout => 300,
  }
}
