class twitch_link_aggregation (
$method = $twitch_link_aggregation::params::method,
) inherits twitch_link_aggregation::params {

  validate_re($method, '^(bond|team)$', "link aggregation method of '${method}' is unsupport/unknown .  Allowed values are 'bond' and 'team'.")

  include twitch_ethtune

  include twitch_ethtune::rxfh_indir

  case $method {
    'bond':  { notice ('No link aggregation applied, bonding on precise has been deprecated.')}
    'team':  { include twitch_teamd }
    default: { notice ('No link aggregation applied') }
  }

}
