# determines LLDP information from ladvdc cli tool

def translate_slot_to_rack(slot_num, pop)
  # this translates the switch slot to rack for newer installations via convention
  # requires slot_num to be numeric and pop
  rack_num = slot_num + 1
  return "r%02i.%s" % [rack_num, pop]
end

def find_usable_slot(slots)
  # pass in slot data as hash, find one that matches the newer installation format ex. Ethernet1/2/3
  # if does not match, return default slot 1 not to break current systems
  slots.each do |slot,data|
    if data.match(/\w(\d+)\/.*$/)
       return $1
    end
    return '1'
  end
end

if not Facter.value('is_virtual')
    if system('which ladvdc >/dev/null 2>&1')
        # call command, separate into array of lines
        # for each line, further split it by equal sign
        # nest that all in an outer array, and splat that
        # shit into a new Hash
        shell_cmd = `timeout -k 3 5 ladvdc -Lb 2>/dev/null`
        if $?.exitstatus
          lldp_info = shell_cmd.split(/\n/).map do |l|
            k, v = l.split('=')
            v.gsub!(/^'|'$/, '') # values are single quoted
            [k, v]
          end
          lldp_info = Hash[*[lldp_info]]
          rack_links = []
          lldp_interfaces = []
          switchports = {}
          slots = {}
          lldp_info.each do |k,v|
            if k.match(/^HOSTNAME[_]{0,1}\d+/)
              rack_links << v
            elsif k.match(/^INTERFACE[_]{0,1}(\d+)/)
              lldp_interfaces << v
              switchports[v] = "%s %s" % [lldp_info[k.gsub(/^INTERFACE/,'HOSTNAME')], lldp_info[k.gsub(/^INTERFACE/,'PORTNAME')]]
              slots[v] = lldp_info[k.gsub(/^INTERFACE/,'PORTNAME')]
            end
          end
        end
      Facter.add("lldp_interfaces") do
        # aggregate fact for lldp_interfaces
        setcode { lldp_interfaces.sort.join(',') }
      end
      # interface switchport names
      switchports.each do |iface,name|
        Facter.add("#{iface}_switchport") do
          setcode { name }
        end
      end

      # each rack_link we get rack number rXX
      rack_name = rack_links.map { |x| x.gsub(/-(?:da|ma)\d+/, '') }.uniq
      unless rack_name.empty?
        if rack_name.first.include? "da"
            slot = find_usable_slot(slots)
            Facter.add("rack_name") { setcode { translate_slot_to_rack(slot.to_i, Facter.value('pop')) } }
        else
            Facter.add("rack_name") { setcode { rack_name.first } }
        end
      end
    end
end
