# twitch_lldp
class twitch_lldp {

  $check_network_drivers = split($::network_drivers,',')

  package { 'ladvd':
    ensure => present,
  }

  service { 'ladvd':
    ensure  => 'running',
    enable  => true,
    require => Package['ladvd'],
  }

  $ensure_i40e_workaround = bool2str('i40e' in $check_network_drivers) ? {
    'true'  => 'present',
    default => 'absent',
  }

  file { '/usr/local/bin/i40_fw_lldp_disable.sh':
    ensure  => $ensure_i40e_workaround,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => "puppet:///modules/${module_name}/i40_fw_lldp_disable.sh",
    require => Package['ladvd'],
  }

  twitch_systemd::drop_in { 'ladvd-overrides.conf':
    ensure  => $ensure_i40e_workaround,
    unit    => 'ladvd.service',
    content => template("${module_name}/ladvd.systemd.dropin.erb"),
    require => [
      File['/usr/local/bin/i40_fw_lldp_disable.sh'],
    ],
    notify  => [
      Service['ladvd'],
      Exec['systemctl daemon-reload'],
    ],
  }

  Exec['systemctl daemon-reload'] -> Service <| title == 'ladvd'  |>
}
