# twitch_lmd::metrics installs the metrics services for lmd
class twitch_lmd::metrics (
  $install_path = '/opt/twitch/lmd',
) inherits twitch_lmd {

  file { $install_path:
    ensure  => 'directory',
    owner   => 'lmd',
    group   => 'lmd',
    mode    => '0755',
    require => Package['lmd'],
    }

  file { "${install_path}/lmd-metrics.py":
    ensure => 'present',
    owner  => 'lmd',
    group  => 'lmd',
    mode   => '0755',
    source => 'puppet:///modules/twitch_lmd/lmd-metrics.py',
  }

  ::twitch_systemd::service { 'lmd_metrics':
    command   =>  "${install_path}/lmd-metrics.py",
    user      => 'lmd',
    group     => 'lmd',
    enable    => $::installed::twitch_lmd,
    timeout   => 30,
    killmode  => 'process',
    after     => ['rsyslog.service', 'network.target'],
    require   => [
      File["${install_path}/lmd-metrics.py"],
    ],
    subscribe => File["${install_path}/lmd-metrics.py"],
    restart   => 'on-failure',
  }

  ::video_cloudwatch::logfile { 'lmd':
    ensure => absent,
  }
  
  ::twitch_svclogs::logfile { 'lmd':
    log_dir          => '/var/log/jtv',
    filename         => 'lmd.log',
    log_group_name   => '/vidops/lmd',
    datetime_format    => '%Y-%m-%d %H:%M:%S',
    use_default_region => true,
  }

}
