class twitch_logster (
  $swname         = 'logster',
  $version        = $twitch_logster::params::logster_version,
  $python_version = $twitch_logster::params::python_version,
  $log_name       = $twitch_logster::params::log_name,
  $spade_output   = $twitch_logster::params::spade_output,
  $spade_pct      = $twitch_logster::params::spade_pct,
) inherits twitch_logster::params {
  include twitch::packages

  realize(Package['logtail'])

  $filename = "${swname}-${version}.tar.gz"

  file { "/home/jtv/cronscripts/${filename}":
    ensure => $ensure,
    owner  => 'jtv',
    group  => 'jtv',
    mode   => '0644',
    source => "puppet:///modules/twitch_logster/${filename}",
  }

  if $log_name {
    $ensure = 'present'
      exec { "install_${swname}":
        command => "easy_install -U ${filename}",
        cwd     => '/home/jtv/cronscripts',
        creates => "/usr/local/lib/python${python_version}/dist-packages/logster-${version}-py${python_version}.egg",
        require => [File["/home/jtv/cronscripts/${filename}"], Class['twitch_python']],
      }
  } else {
    $ensure = 'absent'
  }

  $script_template = "${module_name}/nginx_spade.sh.erb"

  file { '/home/jtv/cronscripts/nginx_spade.sh':
    ensure  => $ensure,
    require => File['/home/jtv/cronscripts/'],
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0755',
    content => template("${script_template}"),
  }

  # This runs every minute.
  cron::job { 'nginx_hls_spade':
    ensure  => $ensure,
    command => '/home/jtv/cronscripts/nginx_spade.sh 2>&1 | logger -p local2.info -t nginx_spade',
    user    => 'jtv',
    require => File['/home/jtv/cronscripts/nginx_spade.sh'],
  }
  # delete this after some time.. -jul2016
  cron {'nginx_hls_spade': user => 'jtv', ensure => 'absent'}
}
