# Populates /etc/hardware/lshw.json
class twitch_lshw (
  $version = $twitch_lshw::params::version
) inherits twitch_lshw::params {

  package { 'lshw':
    ensure => $version,
  }

  exec { 'systemd-tmpfiles for lshw':
    command     => '/bin/systemd-tmpfiles --create --prefix=/etc/hardware',
    refreshonly => true,
  }

  $notifies = $::packer_builder_type ? {
    'docker' => undef,
    default  => Exec['systemd-tmpfiles for lshw']
  }

  file { '/etc/tmpfiles.d/lshw.conf':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "d /etc/hardware 755 root root\n",
    notify  => $notifies,
  }

  systemd::service { 'lshw':
    description       => 'lshw hardware lister',
    before_units      => ['network-online.target'],
    after_units       => ['systemd-tmpfiles-setup.service'],
    execstart         => '/bin/sh -c "/usr/bin/lshw -json > /etc/hardware/lshw.json"',
    type              => 'oneshot',
    wantedby          => ['network-online.target'],
    remain_after_exit => true,
    standard_output   => 'syslog',
    standard_error    => 'syslog',
    syslog_identifier => 'lshw',
    require           => [Package['lshw'],Exec['systemd-tmpfiles for lshw']],
    restart           => 'no',
  }

  # run `lshw` on boot
  service { 'lshw':
    enable  => true,
    require => Systemd::Service['lshw'],
  }

}
