#!/usr/bin/perl
use Cache::Memcached;
use Getopt::Long;
use Switch;


$host = "localhost";
$port = "11211";
$debug = 0;
$memcache_instance = "mc";


GetOptions("help" => \$opt_help, #flag
           "h=s" => \$host,
           "p=s" => \$port,
           "v" => \$debug,
           "n=s" => \$memcache_instance,
           "d" => \$dry_run
          );

if(defined($opt_help)){

print <<'END_USAGE'
Usage: ganglia_memcached.pl [OPTION]...
Collect memcached statistics

Options:
-help Usage information
-h Hostname of memcached. If not supplied defaults to 127.0.0.1
-p Port of memcached. If not supplied defaults to 11211
-v verbose mode
-n name of memcache instance
-d do not sent gmetric
END_USAGE
  ;
  exit;

}

if ( $memcache_instance =~ /\w+/ ) {
  $memcache_instance = $memcache_instance . '_';
}


my $cache = Cache::Memcached->new( { servers => [ "$host:$port"], 'debug' => $debug  } );

$b = $cache->stats;

# memcache version 1.2
#@ax = ("bytes","curr_connections","total_items","cmd_set","bytes_written","evictions","curr_items","rusage_user","cmd_get","rusage_system","get_hits","bytes_read","total_connections","get_misses");
# memcache version 1.4
@ax = ( "pid","uptime","time","pointer_size","rusage_user",
        "rusage_system","curr_connections","total_connections","connection_structures",
        "cmd_get","cmd_set","cmd_flush","get_hits","get_misses","delete_misses",
        "delete_hits","incr_misses","incr_hits","decr_misses","decr_hits","cas_misses",
        "cas_hits","cas_badval","auth_cmds","auth_errors","bytes_read","bytes_written",
        "limit_maxbytes","accepting_conns","listen_disabled_num","threads",
        "conn_yields","expired_unfetched","evicted_unfetched","bytes","curr_items","total_items","evictions","reclaimed"
      );

foreach $key (@ax) {

  switch ($key){
     case "pid" { $slope = "zero" }
     case "uptime" { $slope = "zero" }
     case "time" { $slope = "zero" }
     case "version" { $slope = "zero" }
     case "pointer_size" { $slope = "both" }
     case "bytes" { $slope = "both"}
     case "curr_connections" { $slope = "both"}
     case "curr_items" { $slope = "both"}
     case "limit_maxbytes" { $slope = "both"}
     case "rusage_system" { $slope = "both"}
     case "rusage_user" { $slope = "both"}
     else { $slope = "positive" }
  }

  system("gmetric --name=\"$memcache_instance$key\"\t--value=" . $b->{hosts}->{"$host:$port"}->{misc}->{$key} . "\t--slope=$slope --type=uint32 -x 120");

}
