# manages memcached via daemontools
class twitch_memcached::daemontools inherits twitch_memcached {

  # run the service under daemontools
  daemontools::supervise { 'memcached_1':
    wd      => '/etc/service/memcached_1',
    syslog  => 'local2',
    daemon  => "memcached",
    options => join([
      "-u ${twitch_memcached::memcached_user}",
      "-m ${twitch_memcached::real_memcached_memory}",
      "-t ${twitch_memcached::memcached_threads}",
      "-c ${twitch_memcached::memcached_max_connections}",
      "-l ${twitch_memcached::memcached_listen_address}",
      "-p ${twitch_memcached::memcached_port}",
      "-U 0",
      "-f ${twitch_memcached::memcached_growth_facter}",
      "-n ${twitch_memcached::memcached_min_slab_size}",
      '-r',  # maximize core file limit (debug option)
      '-v',  # print warnings/errors during event loop (debug option)
      $twitch_memcached::memcached_options_string,  # any other options from hiera
      '2>&1',
    ], ' '),
  }
}
