# Provide gmemcached.pl and cron
class twitch_memcached::gmemcached (
  $cron_user = $twitch_memcached::params::memcached_cron_user,
) inherits twitch_memcached {
  include twitch_base::jtv_user

  package { 'libcache-memcached-perl':
    ensure => installed
  }

  # This runs every minute.
  cron::job { 'gmemcached':
    ensure  => present,
    command => '~/cronscripts/gmemcached.pl',
    user    => $cron_user,
    require => File["/home/${cron_user}/cronscripts/gmemcached.pl"]
  }
  # Remove this after a while. -july2016
  cron {'gmemcached': ensure => 'absent', user => $cron_user}

  file{ "/home/${cron_user}/cronscripts/gmemcached.pl":
    ensure  => present,
    mode    => '0755',
    source  => 'puppet:///modules/twitch_memcached/gmemcached.pl',
    require => [
      Class['twitch_base::jtv_user'],
      Package['libcache-memcached-perl']
    ],
  }
}
