# Base class to install memcached controoled via daemontools
class twitch_memcached (
  $cron_user                 = $twitch_memcached::params::memcached_cron_user,
  $memcached_user            = $twitch_memcached::params::memcached_user,
  $memcached_port            = $twitch_memcached::params::memcached_port,
  $memcached_options         = $twitch_memcached::params::memcached_options,
  $memcached_memory          = $twitch_memcached::params::memcached_memory,
  $memcached_growth_facter   = $twitch_memcached::params::memcached_growth_facter,
  $memcached_min_slab_size   = $twitch_memcached::params::memcached_min_slab_size,
  $memcached_listen_address  = $twitch_memcached::params::memcached_listen_address,
  $memcached_max_connections = $twitch_memcached::params::memcached_max_connections,
  $memcached_version         = $twitch_memcached::params::memcached_version,
  $maximize_memory_size      = $twitch_memcached::params::maximize_memory_size,
  $process_manager           = $twitch_memcached::params::process_manager,
  $consul_prefix             = $twitch_memcached::params::consul_prefix,
) inherits twitch_memcached::params {

  include twitch_python::pip::install
  include twitchtv

  validate_bool($maximize_memory_size)

  # this formulates the string of extra options to pass to memcached daemons
  # $memcached_options can be either an Array or a String
  # it prefixes every element in the array with '-o '
  $memcached_options_string = join(prefix(flatten([$memcached_options]), '-o '), ' ')

  # allow systems to allocate 3/4 of available memory as cache, otherwise use default
  # or passed in $memcached_memory
  if $maximize_memory_size {
    $real_memcached_memory = floor($::memorysize_mb * 0.75)
  } else {
    $real_memcached_memory = $memcached_memory
  }

  # install the memcached package
  package { 'memcached':
    ensure => $memcached_version,
  }

  # install the python-memcached package at the system level
  # we use this to retrieve stats via Nagios/NRPE
  package { 'python-memcached':
    ensure   => '1.53',
    provider => 'twitch_pip',
    require  => Class['twitch_python::pip::install'],
  }

  # configure process manager
  if member($valid_process_managers, $process_manager) {
    class { "twitch_memcached::${process_manager}":
      require => Package['memcached'],
    }
  } else {
    fail("Invalid process manager in twitch_memcached: ${process_manager}")
  }

  consul::service { "web-${consul_prefix}-memcached":
    port        => $memcached_port,
    consul_tags => [$twitchtv::consul_deploy_tag],
  }
}
