# manages memcached via upstart
class twitch_memcached::upstart inherits twitch_memcached {

  # run the service under upstart
  upstart::job { 'memcached':
    description   => 'memcached',
    respawn       => true,
    respawn_limit => '6 60',
    user          => 'root',
    exec          => join([
      "memcached",
      "-u ${twitch_memcached::memcached_user}",
      "-m ${twitch_memcached::real_memcached_memory}",
      "-t ${twitch_memcached::memcached_threads}",
      "-c ${twitch_memcached::memcached_max_connections}",
      "-l ${twitch_memcached::memcached_listen_address}",
      "-p ${twitch_memcached::memcached_port}",
      "-f ${twitch_memcached::memcached_growth_facter}",
      "-n ${twitch_memcached::memcached_min_slab_size}",
      $twitch_memcached::memcached_options_string,
    ], ' '),
  }
}
