# twitch wrapper for creating monit services
define twitch_monit::check(
  $cwd,
  $uid,
  $pidfile        = undef,
  $regex          = undef,
  $ensure         = 'present',
  $gid            = undef,
  $command        = undef,
  $start_program  = undef,
  $stop_program   = undef,
  $alert_email    = undef,
  $check_interval = 40,
  $env            = 'PATH=$PATH:/usr/local/bin',
  $service_checks = {},
  $custom_checks  = [],
  $monit_template = 'twitch_monit/monit_check.erb',
) {

  include twitch_monit
  include monit

  # global daemon checks in seconds
  # service checks are based on cycle from daemon interval
  # calculate what the user wants and validate to a reasonable global
  $service_check_interval = $check_interval/$twitch_monit::check_interval

  validate_integer($service_check_interval)
  validate_hash($service_checks)
  validate_array($custom_checks)
  validate_string($alert_email)

  monit::check { $name:
    ensure  => $ensure,
    content => template($monit_template)
  }

  if $ensure == 'present' {
    service { "monit-${name}":
      provider => 'base',
      restart  => "/usr/bin/monit restart ${name}",
      start    => "/usr/bin/monit start ${name}",
      status   => "/usr/bin/monit status ${name}", # might not return exit code
      stop     => "/usr/bin/monit stop ${name}",
      require  => Class['monit'],
    }
  }
}
