# Class twitch_monit
class twitch_monit (
  $mmonit_url         = $twitch_monit::params::mmonit_url,
) inherits twitch_monit::params {
  class { 'monit':
    httpd          => true,
    httpd_address  => '127.0.0.1',
    mailserver     => 'localhost',
    check_interval => $twitch_monit::params::check_interval,
  }

  file { "${monit::config_dir}/README":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "# This directory is managed by puppet.\n",
    require => File[$monit::config_dir],
  }

  if $mmonit_url {
    # monit module does not allow for https:// urls in monitrc, work around by adding more configuration to confd dir
    ::monit::check { 'mmonit_url':
      content => "set mmonit ${mmonit_url}\n  and register without credentials\n",
    }
  }

}
