#!/bin/bash

query="select (select count(*) from ad_revenue_stats where report_date > (now() - interval '2 days')) as num, (now() at time zone 'PDT' - max(created_on) at time zone 'UTC') as freshness, ((now() at time zone 'PDT' - max(created_on) at time zone 'UTC') < '24 hours') and ((select count(*) from ad_revenue_stats where report_date > (now() - interval '2 days')) > 500) as all_good from ad_revenue_stats /* nagios check testing if ad stats are out of sync */"
SQL=$(psql -F \/ -U nagios justintv_prod -t -c "$query" | head -1 | tr \| ,)
EXIT_VALUE=$?

if echo $SQL | grep -q t$ ; then
    echo "OK: ads stats synced ($SQL)"
    exit 0
else
    echo "CRITICAL: ads stats out of sync ($SQL)"
    exit 2
fi

# if we get this far, return unknown
echo "UNKNOWN: Check failed"
exit 3
