#!/bin/bash
# Simple script to report postfix queues status for Nagios.
# Can be used with NRPE or NRDP.
# OK: all queues are below threshold
# WARN: some queues are above warning threshold
# CRIT: some queues are above critical threshold

set -u -e

crit=1000
warn=500

usage() {
    echo $1
    echo
    echo "Usage: $(basename $0) [-c crit_length] [-w warn_length]"
    exit 1
}

while [ $# -gt 0 ]; do
    case "$1" in
        -c)
            crit=${2:-}
            (( crit < 1 )) && usage "-c takes integer positive argument"
            shift 2
            ;;
        -w)
            warn=${2:-}
            (( warn < 1 )) && usage "-w takes integer positive argument"
            shift 2
            ;;
        *)
            usage "unknown option $1"
            ;;
    esac
done

warn_status="false"
crit_status="false"
while read queue_name queue_length; do
    case $queue_name in
        incoming|deferred|bounce)
            ((queue_length > crit)) \
                && echo "CRITICAL: $queue_name length is $queue_length" \
                && crit_status="true" \
                && continue
            ((queue_length > warn)) \
                && echo "WARNING: $queue_name length is $queue_length" \
                && warn_status="true" \
                && continue
            echo "OK: $queue_name length is $queue_length"
            ;;
    esac
done < <(echo stats|nc 127.0.0.1 7777|jq -r '.queue | keys[] as $k | "\($k) \(.[$k])"')

"$crit_status" && exit 2
"$warn_status" && exit 1
exit 0
