#!/bin/bash
# Simple script to check consul and deploy status for Nagios.
# Can be used with NRPE or NRDP.
# OK: Both Enabled
# WARN: Consul Disabled
# CRIT: Deploys Disabled
# Passing -c will make Consul Disabled throw CRIT too.

consul_check_url="http://localhost:8500/v1/agent/checks"
[ -x /usr/bin/curl ] && consul_check_command="/usr/bin/curl --silent --max-time 15"
[ -x /usr/bin/wget ] && consul_check_command="/usr/bin/wget -q -O - --timeout=15"
status_output=$(${consul_check_command:-true} "$consul_check_url")

[ -z "$status_output" ] && echo "UNKNOWN: failed to get consul status" && exit 3

consul_status=$(echo $status_output | /usr/bin/jq --raw-output '.["node-enabled"].Status')
deploy_status=$(echo $status_output | /usr/bin/jq --raw-output '.["service:deploy"].Status')

consul=""
deploy=""
test "$consul_status" = "passing" && consul="enabled"
test "$deploy_status" = "passing" && deploy="enabled"

STATUS=2
MSG="CRITICAL: Consul & Deploys - BOTH DISABLED"

if [ "$consul" ] && [ "$deploy" ]; then
  STATUS=0
  MSG="OK: Consul Enabled\nOK: Deploys Enabled"
elif [ "$consul" ]; then
  MSG="CRITICAL: Deploys DISABLED\nOK: Consul Enabled"
elif [ "$deploy" ]; then
  STATUS=1
  MSG="WARNING: Consul DISABLED\nOK: Deploys Enabled"
  if [ "$1" = "-c" ]; then
    STATUS=2
    MSG="CRITICAL: Consul DISABLED\nOK: Deploys Enabled"
  fi
fi

echo -e $MSG
exit $STATUS
