#!/bin/sh

DEFAULT_IFACE=$(ip route get 192.168.255.255 | head -1 | cut -f 5 -d " ")
CONSUL_IP=$(jq -r '.advertise_addr' /etc/consul.d/main.json 2>/dev/null)
IFCONFIG_IPS=$(ip -f inet -o addr show $DEFAULT_IFACE 2>/dev/null | cut -d\  -f 7 | cut -d/ -f 1)

MSG="CRITICAL: Consul IP (${CONSUL_IP}) differs from $DEFAULT_IFACE ($IFCONFIG_IP), see /etc/consul.d/main.json"
STATUS=2

if [ -z "$IFCONFIG_IPS" ]
then
  echo "CRITICAL: No $DEFAULT_IFACE ip found!"
  exit $STATUS
fi

for IFCONFIG_IP in $IFCONFIG_IPS
do
  if [ "$CONSUL_IP" = "$IFCONFIG_IP" ]
  then
    MSG="OK: Consul IP ($CONSUL_IP) matches interface $DEFAULT_IFACE."
    STATUS=0
  fi
done

echo $MSG
exit $STATUS
